using System;
using Server;
using Server.Spells;
using Server.Items;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName( "a forest elf corpse" )]
	public class WispScholar : BaseCreature
	{
		private DateTime m_Summon = DateTime.Now;
		private bool m_Dark = false;

		public override bool ShowFameTitle { get { return false; } }
		public override bool AlwaysAttackable { get { return true; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool CanRummageCorpses { get { return false; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }

		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.MortalStrike;
				case 2: return WeaponAbility.ArmorIgnore;
			}
		}

		[Constructable]
		public WispScholar() : this(false)
		{
		}

		[Constructable]
		public WispScholar(bool dark) : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			m_Dark = dark;
			Hue = Utility.RandomSkinHue();
			SpeechHue = m_Dark ? 2222 : Utility.RandomDyedHue();
			EmoteHue = Utility.RandomNeutralHue();
			int OutfitHue = m_Dark ? Utility.RandomMinMax(1663, 1671) : Utility.RandomMinMax(2106, 2130);

			if (this.Female = Utility.RandomBool())
			{
				Body = 0x191;
				Name = NameList.RandomName("female");
				AddItem(new Skirt(1175));
				AddItem(new Bonnet(OutfitHue));
			}
			else
			{
				Body = 0x190;
				Name = NameList.RandomName("male");
				AddItem(new LongPants(1175));
				AddItem(new FloppyHat(OutfitHue));
				Utility.AssignRandomFacialHair(this, HairHue);
			}

			// hair, facial hair
			Utility.AssignRandomHair(this);
			HairHue = DarkElf.RandomDarkElfHairHue;
			Title = "the Scholar";

			SetStr(406, 500);
			SetDex(100, 135);
			SetInt(450, 505);

			SetDamage(19, 29);
			SetHits(751, 795);
			SetMana(1450, 1500);

			// 			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance(ResistanceType.Physical, 50, 60);
			SetResistance(ResistanceType.Fire, 50, 70);
			SetResistance(ResistanceType.Cold, 60, 65);
			SetResistance(ResistanceType.Poison, 55, 60);
			SetResistance(ResistanceType.Energy, 50, 65);

			SetSkill(SkillName.SpiritSpeak, 80.0, 100.0);
			SetSkill(SkillName.MagicResist, 80.0, 110.0);
			SetSkill(SkillName.Swords, 100.0, 130.0);
			SetSkill(SkillName.Fencing, 100.0, 130.0);
			SetSkill(SkillName.Macing, 100.0, 130.0);
			SetSkill(SkillName.Tactics, 100.0, 130.0);
			SetSkill(SkillName.Wrestling, 100.0, 130.0);
			SetSkill(SkillName.Anatomy, 100.0, 110.0);
			SetSkill(SkillName.Necromancy, 80.0, 110.0);
			SetSkill(SkillName.Parry, 60.0, 90.0);
			SetSkill(SkillName.Magery, 80.0, 110.0);
			SetSkill(SkillName.EvalInt, 100.1, 120.0);
			SetSkill(SkillName.Healing, 70.0, 90.0);
			SetSkill(SkillName.AnimalTaming, 120.0);
			SetSkill(SkillName.Meditation, 120.0);
			SetSkill(SkillName.Spellweaving, 110.1, 120.0);

			// outfit
			AddItem(new Sandals(OutfitHue));
			AddItem(new Cloak(OutfitHue));
			AddItem(new FancyShirt(m_Dark ? 1175 : 0));

			Item staff = new GnarledStaff();
			staff.Hue = OutfitHue;
			((BaseWeapon)staff).WeaponAttributes.HitHarm = 20;
			staff.Movable = false;
			AddItem(staff);
			//end outfit

			Fame = 4000;
			Karma = -7000;
			VirtualArmor = 46;
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Miscellaneous);
			AddLoot(LootPack.HighScrolls, 2);
		}

		public override bool IsNotScaredOfDeath { get { return m_Dark ? false : Utility.RandomBool(); } } //neutika pri malem poctu hp - sance 50%

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if (Utility.RandomDouble() < 0.06 && from.Player)
			{
				KhalAnkur.Waller(3, 8, from);
			}

			if (Utility.RandomDouble() < 0.07 && this.Hits < (this.HitsMax * 50) / 100)
			{
				Server.Engines.XmlSpawner2.FlareVortex vortex = new Server.Engines.XmlSpawner2.FlareVortex();

				vortex.ItemID = 8448;
				vortex.Hue = 1360;
				vortex.Name = null;
				vortex.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 10), from.Map);
			}
		}

		public WispScholar(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			if (SpeechHue == 2222) m_Dark = true;
		}
	}
}